#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Bimbel Ahe Blitar', '6281327904039', 'rahatriyuniar@gmail.com', 'Kaweron,Talun,Blitar, Jawa Timur', 'Logo-1754370495.png');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kelas
#

DROP TABLE IF EXISTS `tb_kelas`;

CREATE TABLE `tb_kelas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelas` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (35, 'AHE', '2025-09-14 11:10:35');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (36, 'ASE', '2025-09-14 11:10:45');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (37, 'AGA', '2025-09-14 11:11:02');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (38, 'YES ENGLISH', '2025-09-14 11:11:33');


#
# TABLE STRUCTURE FOR: tb_kelas_peserta
#

DROP TABLE IF EXISTS `tb_kelas_peserta`;

CREATE TABLE `tb_kelas_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `tglLulus` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (639, 1, 469, 36, '130000', 1, 'Lulus', '2025-09-14', '2025-09-14 11:15:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (640, 1, 468, 35, '130000', 1, 'Tidak Aktif', '0000-00-00', '2025-09-14 11:21:04');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (641, 1, 467, 35, '130000', 2, 'Tidak Aktif', '0000-00-00', '2025-09-14 11:22:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (642, 1, 464, 37, '100000', 3, 'Aktif', '0000-00-00', '2025-09-14 11:27:16');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (643, 1, 469, 38, '130000', 1, 'Aktif', '0000-00-00', '2025-09-14 12:09:23');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4083 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4071, 1, '180.247.75.9', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-13 20:41:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4072, 1, '2001:448a:50e2:8b75:59df:224a:ce', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Logout', '2025-09-13 20:43:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4073, 1, '2001:448a:50e2:8b75:59df:224a:ce', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-13 20:43:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4074, 1, '2001:448a:50e2:8b75:59df:224a:ce', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Logout', '2025-09-13 20:44:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4075, 1, '2001:448a:50e2:8b75:59df:224a:ce', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-13 20:45:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4076, 1, '114.5.242.116', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 OPR/90.0.0.0', 'Login', '2025-09-13 22:57:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4077, 1, '114.5.242.116', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 OPR/90.0.0.0', 'Logout', '2025-09-13 22:58:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4078, 1, '118.99.112.6', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-14 10:53:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4079, 11, '118.99.112.6', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-14 11:38:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4080, 11, '118.99.112.6', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Logout', '2025-09-14 12:10:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4081, 1, '114.10.154.185', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 OPR/90.0.0.0', 'Login', '2025-09-14 12:15:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4082, 1, '118.99.112.6', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36', 'Login', '2025-09-14 12:16:31');


#
# TABLE STRUCTURE FOR: tb_setting
#

DROP TABLE IF EXISTS `tb_setting`;

CREATE TABLE `tb_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_subdomain` varchar(100) DEFAULT NULL,
  `expired_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_setting` (`id`, `nama_subdomain`, `expired_at`) VALUES (1, 'demo', '2025-09-19');


#
# TABLE STRUCTURE FOR: tb_siswa
#

DROP TABLE IF EXISTS `tb_siswa`;

CREATE TABLE `tb_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `noInduk` varchar(16) NOT NULL,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(16) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `tglLahir` date NOT NULL,
  `tglMasuk` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=470 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (464, '25001', 'Muhammad Arrasya Muzakki', 'Laki-Laki', '6281213080985', '2023-02-10', '2025-07-01', '2025-07-14 14:10:10');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (467, '25002', 'Muhammad Farell Alexandra', 'Laki-Laki', '6285735390007', '2014-12-16', '2025-07-01', '2025-07-26 20:23:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (468, '25003', 'Naufaliyn Alesa', 'Perempuan', '6285744223566', '2021-10-15', '2025-02-02', '2025-08-07 16:45:41');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (469, '625004', 'M.Fatih Rahadika', 'Laki-Laki', '6281327904039', '2015-12-07', '2022-04-01', '2025-09-14 11:14:33');


#
# TABLE STRUCTURE FOR: tb_tagihan
#

DROP TABLE IF EXISTS `tb_tagihan`;

CREATE TABLE `tb_tagihan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `bulan` int(11) NOT NULL,
  `tahun` int(11) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (63, 1, 9, 2025, '2025-09-14 11:28:20');


#
# TABLE STRUCTURE FOR: tb_tagihan_siswa
#

DROP TABLE IF EXISTS `tb_tagihan_siswa`;

CREATE TABLE `tb_tagihan_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTagihan` int(11) NOT NULL,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `jam` time NOT NULL,
  `tglBayar` date NOT NULL,
  `approve` varchar(64) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4598 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4594, 63, 11, 469, 36, '130000', 1, 'Sudah Bayar', '11:40:31', '2025-09-14', 'Approve', '2025-09-14 11:28:20');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4595, 63, 1, 468, 35, '130000', 1, 'Sudah Bayar', '11:53:33', '2025-09-14', 'Approve', '2025-09-14 11:28:20');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4597, 63, 1, 464, 37, '100000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2025-09-14 11:28:20');


#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Rahatri Yuniar', 'Perempuan', '6281327904039', 'rahatriyuniar@gmail.com', 'Kaweron,Talun,Blitar, Jawa Timur', 'Rahatri', '$2y$10$PaPXo8lil95tixkPnBiJ/uvVgnGGdwh10GkzTmJ3AlIEiwBLcMR0i', 'Profil-1752559733.png', 'yellow', 'Administrator', 'Ya', '2023-05-20 09:36:23');
INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (11, 'Afidatul Ida', 'Perempuan', '62857755559', 'andikawidjaya@gmail.com', 'KAWERON', 'Ida001', '$2y$10$NddpYAWPdzhHZtxLYmTqn.qWVZ/xVmzFJ0nrjZkeY8NnXcwqaf7r6', 'no-image.png', 'blue', 'Pegawai', 'Ya', '2025-09-14 11:36:33');


